IF NOT OBJECT_ID ('TRG_EST_NF_SAI_IT_EST_SNGPC_SAIDA_EXCLUSAO') IS NULL
	BEGIN 
		DROP TRIGGER TRG_EST_NF_SAI_IT_EST_SNGPC_SAIDA_EXCLUSAO
	END 
GO
 
CREATE TRIGGER [dbo].[TRG_EST_NF_SAI_IT_EST_SNGPC_SAIDA_EXCLUSAO] ON [dbo].[EST_NF_SAI_IT_EST_SNGPC_SAIDA]
WITH EXECUTE AS CALLER
FOR INSERT, UPDATE, DELETE
AS
BEGIN

	-- VERIFICA A QUANTIDADE J INSERIDA E A QUANTIDADE CANCELADA
	DECLARE @QTDE INTEGER;
	DECLARE @QTDECANCEL INTEGER;

	SET @QTDE = (
		SELECT
			COALESCE(SUM(A.QT_LOTE), 0)
		FROM
			EST_SNGPC_SAIDA A
			INNER JOIN EST_NF_SAI_IT_EST_SNGPC_SAIDA B ON
				A.CD_SAI_SNGPC = B.CD_SAI_SNGPC				
			INNER JOIN INSERTED I ON
				B.CD_EMP        = I.CD_EMP
				AND B.CD_FILIAL = I.CD_FILIAL
				AND B.CD_NF     = I.CD_NF
				AND B.CD_PROD   = I.CD_PROD
				AND B.CD_IT     = I.CD_IT
	);

	SET @QTDECANCEL = (
		SELECT
			COALESCE(SUM(A.QT_CANCEL), 0)
		FROM
			EST_NF_SAI_IT_EST_SNGPC_PENDENTE_CANCELADO A
			INNER JOIN INSERTED I ON
				A.CD_EMP        = I.CD_EMP
				AND A.CD_FILIAL = I.CD_FILIAL
				AND A.CD_NF     = I.CD_NF
				AND A.CD_PROD   = I.CD_PROD
				AND A.CD_IT     = I.CD_IT
	);

	-- VERIFICA SE A QUANTIDADE INSERIDA BATE COM A QUANTIDADE DA VENDA
	IF EXISTS (
		SELECT 
			A.QT_IT
		FROM
			EST_NF_SAI_IT A
			INNER JOIN INSERTED I ON
				A.CD_EMP        = I.CD_EMP
				AND A.CD_FILIAL = I.CD_FILIAL
				AND A.CD_NF     = I.CD_NF
				AND A.CD_PROD   = I.CD_PROD
				AND A.CD_IT     = I.CD_IT
		WHERE
			(A.QT_IT - @QTDECANCEL) = @QTDE
	)
		BEGIN
			-- REMOVE A PENDNCIA DE SADA NO SNGPC
			DELETE 
					E
			FROM 
				EST_NF_SAI_IT_EST_SNGPC_PENDENTE E 
				INNER JOIN INSERTED I ON
					E.CD_EMP        = I.CD_EMP
					AND E.CD_FILIAL = I.CD_FILIAL
					AND E.CD_NF     = I.CD_NF
					AND E.CD_PROD   = I.CD_PROD
					AND E.CD_IT     = I.CD_IT;
		END

	ELSE
		BEGIN
			-- VERIFICA SE A PENDNCIA AINDA EXISTE
			IF NOT EXISTS (
				SELECT 
					A.CD_EMP
				FROM
					EST_NF_SAI_IT_EST_SNGPC_PENDENTE A
					INNER JOIN DELETED D ON
						A.CD_EMP        = D.CD_EMP
						AND A.CD_FILIAL = D.CD_FILIAL
						AND A.CD_NF     = D.CD_NF
						AND A.CD_PROD   = D.CD_PROD
						AND A.CD_IT     = D.CD_IT
				)
				BEGIN
					-- INSERE A PENDNCIA NOVAMENTE
					INSERT INTO EST_NF_SAI_IT_EST_SNGPC_PENDENTE
						SELECT 
							CD_EMP, 
							CD_FILIAL,
							CD_NF,
							CD_PROD,
							CD_IT,
							GETDATE()
						FROM 
							DELETED;
				END;
		END;
END
GO